[#ftl]
[#-- V1.2.0 --]
[#if (Peripherals?contains("USBHS0") == true && USBHS0_USB0Type == "USBFS" && USBHS048MSEL == "RCU_USBHSx48M_CKSRC_USBHSDV") || (Peripherals?contains("USBHS0") == true && USBHS0_USB0Type == "USBHS" && USBHS0SEL == "RCU_USBHSx_CKSRC_CK60M") || (Peripherals?contains("USBHS1") == true && USBHS1_USB1Type == "USBFS" && USBHS148MSEL == "RCU_USBHSx48M_CKSRC_USBHSDV") || (Peripherals?contains("USBHS1") == true && USBHS1_USB1Type == "USBHS" && USBHS1SEL == "RCU_USBHSx_CKSRC_CK60M")]
void msd_pllusb_config(void)
{
    hal_rcu_pll_struct rcu_pll_parameter;
    hal_rcu_periphclk_struct rcu_periphclk_parameter;

    hal_rcu_struct_init(HAL_RCU_PLL_STRUCT, &rcu_pll_parameter);
    hal_rcu_struct_init(HAL_RCU_PERIPHCLK_STRUCT, &rcu_periphclk_parameter);

    [#if Peripherals?contains("USBHS0") == true && (USBHS0SEL == "RCU_USBHSx_CKSRC_CK60M" || (USBHS0SEL == "RCU_USBHSx_CKSRC_CK48M" && USBHS048MSEL == "RCU_USBHSx48M_CKSRC_USBHSDV"))]
    rcu_pll_parameter.state = RCU_OSC_ON;
    rcu_pll_parameter.need_configure = ENABLE;
    rcu_pll_parameter.pllusb0.pllusb0_state = RCU_OSC_ON;
    [#if PLLUSBHS0PRESEL != ""]
    rcu_pll_parameter.pllusb0.pllusb0_preclock_source = ${PLLUSBHS0PRESEL};
    [#else]
    rcu_pll_parameter.pllusb0.pllusb0_preclock_source = RCU_PLLUSBHSx_CKSRC_HXTAL;
    [/#if]
    rcu_pll_parameter.pllusb0.pllusb0_presel = ${PLLUSBHS0PREDV};
    rcu_pll_parameter.pllusb0.pllusb0_mul = ${PLLUSBHS0MF};
	[/#if]
    [#if Peripherals?contains("USBHS1") == true && (USBHS1SEL == "RCU_USBHSx_CKSRC_CK60M" || (USBHS1SEL == "RCU_USBHSx_CKSRC_CK48M" && USBHS148MSEL == "RCU_USBHSx48M_CKSRC_USBHSDV"))]
    [#if !(Peripherals?contains("USBHS0") == true && (USBHS0SEL == "RCU_USBHSx_CKSRC_CK60M" || (USBHS0SEL == "RCU_USBHSx_CKSRC_CK48M" && USBHS048MSEL == "RCU_USBHSx48M_CKSRC_USBHSDV")))]
    rcu_pll_parameter.state = RCU_OSC_ON;
    rcu_pll_parameter.need_configure = ENABLE;
    [/#if]
    rcu_pll_parameter.pllusb1.pllusb1_state = RCU_OSC_ON;
    [#if PLLUSBHS1PRESEL != ""]
    rcu_pll_parameter.pllusb1.pllusb1_preclock_source = ${PLLUSBHS1PRESEL};
    [#else]
    rcu_pll_parameter.pllusb1.pllusb1_preclock_source = RCU_PLLUSBHSx_CKSRC_HXTAL;
    [/#if]
    rcu_pll_parameter.pllusb1.pllusb1_presel = ${PLLUSBHS1PREDV};
    rcu_pll_parameter.pllusb1.pllusb1_mul = ${PLLUSBHS1MF};
	[/#if]
    if(HAL_ERR_NONE != hal_rcu_pll_config(&rcu_pll_parameter)){
        while(1);
    }

    [#if Peripherals?contains("USBHS0") == true && ((USBHS048MSEL == "RCU_USBHSx48M_CKSRC_USBHSDV" || USBHS0SEL == "RCU_USBHSx_CKSRC_CK60M")
    && (USBHS148MSEL != "RCU_USBHSx48M_CKSRC_USBHSDV" && USBHS1SEL != "RCU_USBHSx_CKSRC_CK60M"))]
    rcu_periphclk_parameter.periph_clock_type = RCU_PERIPH_CLKTYPE_USBHS0;
    [#elseif Peripherals?contains("USBHS1") == true && ((USBHS148MSEL == "RCU_USBHSx48M_CKSRC_USBHSDV" || USBHS1SEL == "RCU_USBHSx_CKSRC_CK60M")
    && (USBHS048MSEL != "RCU_USBHSx48M_CKSRC_USBHSDV" && USBHS0SEL != "RCU_USBHSx_CKSRC_CK60M"))]
    rcu_periphclk_parameter.periph_clock_type = RCU_PERIPH_CLKTYPE_USBHS1;
    [#elseif (Peripherals?contains("USBHS0") == true && (USBHS048MSEL == "RCU_USBHSx48M_CKSRC_USBHSDV" || USBHS0SEL == "RCU_USBHSx_CKSRC_CK60M")) &&
             (Peripherals?contains("USBHS1") == true && (USBHS148MSEL == "RCU_USBHSx48M_CKSRC_USBHSDV" || USBHS1SEL == "RCU_USBHSx_CKSRC_CK60M"))]
    rcu_periphclk_parameter.periph_clock_type = RCU_PERIPH_CLKTYPE_USBHS0 | RCU_PERIPH_CLKTYPE_USBHS1;
	[/#if]
    [#if USBHS048MSEL == "RCU_USBHSx48M_CKSRC_USBHSDV"]
    rcu_periphclk_parameter.usb0_clock.usbhs_div = ${USBHS0DV};
	[/#if]
    [#if Peripherals?contains("USBHS0") == true && (USBHS048MSEL == "RCU_USBHSx48M_CKSRC_USBHSDV" || USBHS0SEL == "RCU_USBHSx_CKSRC_CK60M")]
    rcu_periphclk_parameter.usb0_clock.usbhs_clock_source = ${USBHS0SEL};
	[/#if]
    [#if Peripherals?contains("USBHS0") == true && (USBHS048MSEL == "RCU_USBHSx48M_CKSRC_USBHSDV" && USBHS0SEL == "RCU_USBHSx_CKSRC_CK48M")]
    rcu_periphclk_parameter.usb0_clock.usbhs48m_source = ${USBHS048MSEL};
	[/#if]
    [#if USBHS148MSEL == "RCU_USBHSx48M_CKSRC_USBHSDV"]
    rcu_periphclk_parameter.usb1_clock.usbhs_div = ${USBHS1DV};
	[/#if]
    [#if Peripherals?contains("USBHS1") == true && (USBHS148MSEL == "RCU_USBHSx48M_CKSRC_USBHSDV" || USBHS1SEL == "RCU_USBHSx_CKSRC_CK60M")]
    rcu_periphclk_parameter.usb1_clock.usbhs_clock_source = ${USBHS1SEL};
	[/#if]
    [#if Peripherals?contains("USBHS1") == true && (USBHS148MSEL == "RCU_USBHSx48M_CKSRC_USBHSDV" && USBHS1SEL == "RCU_USBHSx_CKSRC_CK48M")]
    rcu_periphclk_parameter.usb1_clock.usbhs48m_source = ${USBHS148MSEL};
	[/#if]
    if(HAL_ERR_NONE != hal_rcu_periph_clock_config(&rcu_periphclk_parameter)){
        while(1);
    }
}
[/#if]
